package telegram;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.bots.AbsSender;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;

public class BotLambda {
	private static final BotAuth USER = getAuth();
	private static final AbsSender SENDER = Config.sender(USER.getToken(), USER.getUsername());
	//private static String userDetails=null;

	public Object handleRequest(Object input, Context context) {
		//System.out.println("Input=" + input);
		//UserDetails user;
		
		String responseText = "";
		String requestText="";
		ObjectMapper mapper = new ObjectMapper();
		Update update = null;
		//String otp;
		try {
			ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
			String json = ow.writeValueAsString(input);
			update = mapper.readValue(json, Update.class);
			
			requestText = update.getMessage().getText();
			//System.out.println("Message=="+update.getMessage());
			responseText = getResponseText(requestText,update.getMessage().getChatId().toString());
			String chatID = update.getMessage().getChatId().toString();
			
			sendMessage(responseText,chatID);
		}catch (Exception e) {
			System.out.println(e.getMessage());
		}
		return "BOT is running"+input;
		
	}
	private String getResponseText(String requestText,String chatId) {
		String responseText="";
		Utils util = new Utils();
		System.out.println("ResquestTest="+requestText);
		System.out.println("chatid="+chatId);
		if(requestText.equalsIgnoreCase("/start")) {
			responseText= "Please Enter Your Email ID";
		}
		else if(requestText.length()==6 && util.isNumber(requestText)) {
			
			String otpResult = util.varifyOTP(chatId, requestText);
			System.out.println("Verify result"+otpResult);
			
			responseText=otpResult.contains("OTP Verified")
					?"Thank you for verifying your OTP. \n\n Your account has been successfully authenticated and is now active."
					:"Sorry OTP is wrong try again to enter OTP or please send your Email";
		} 
		else if(util.checkEmail(requestText)) {
			
			UserDetails user=null;
			user = util.getUserDetails(requestText);//done
			
			if(user.getIsError().equalsIgnoreCase("N")) {
				String otp = util.generateOtp();
				util.sendEmail(user.getEmail(), otp);
				String chatIdStoreResult = util.addChatIdOtp(chatId, otp);//done
				System.out.println("Chat id store response"+chatIdStoreResult);
				if(chatIdStoreResult.contains("OTP Stored"))
				{
					
					if(util.addUserChatid(user, chatId, USER.getToken())) {//done
						System.out.println("Chatid and user saved success");
					responseText = "Thank you to connecting Vision BOT. \n\n We have sent a OTP on your Email "+user.getEmail()
					+"\n\n Please enter OTP to verify";
					}
					else {
						System.out.println("Chatid and user Not saved ");
					}
					
				}
				
			}
			else {
				responseText= "User Not Found";
			}
		}
		else {
			responseText= "Enter Valied Email ID";
		}
		if(responseText.length()==0 ||responseText.equals("")) {
			//return "Could not found result please try again";
			return "Some Issue occurred. Please Contact System Administrator.";
		}
		return responseText;
	}
	public static BotAuth getAuth() {
		BotAuth user = null;
		try {
			Properties properties = new Properties();
			InputStream input = BotLambda.class.getResourceAsStream("/resources/api.properties");
			properties.load(input);

			user = new BotAuth();
			user.setToken(properties.getProperty("TELEGRAM_BOT_TOKEN"));
			user.setUsername(properties.getProperty("TELEGRAM_BOT_USER_NAME"));
			return user;
		} catch (IOException e) {
			e.printStackTrace();
			return user;
		}
	}

	void sendMessage(String text, String chatid) throws TelegramApiException {
		SendMessage send = new SendMessage();
		send.setText(text);
		send.setChatId(chatid);
		send.setParseMode("html");
		Message message = SENDER.execute(send);
		System.out.println("Message send Success..." + message.getText());
	}
	boolean isOtp(String response) {
		if(response==null || response.length()!=6 ) {
			return false;
		}
		try {
			Integer.parseInt(response);
			return true;
		}catch(NumberFormatException e) {
			e.printStackTrace();
			return false;
		}
		
	}
    
}
